// Test program for arrays using JLiveWindow
public class TestArrays extends JLiveWindow {
   // Method main is used to test methods that use arrays,
   // using class JLive Window. It creates one instance of
   // JLiveWindow with 7 int fields. When the READY button
   // is pressed, the first int field is read and stored
   // into variable n; n should be a number between 1 and
   // 6. The next n int fields are then read into an array
   // of size n, and method numberLess is called to return
   // the number of values that are less than 5, and this
   // number is then printed on the Java Console.
   // 
   // You can use main to test numberLess with several
   // different arrays, and of different sizes, all in one
   // run of the program.
   
   // Change main to test other methods in the same manner.
   
   // A constructor: a GUI window with i int fields, d
   // double fields, and s string fields
   public TestArrays(int i, int d, int s)
      {super(i, d, s);}
      
   public static void main(String pars[]) {
      // Create and store in d a new GUI, which has 7 int
      // fields.
         TestArrays d= new TestArrays(7,0,0);
         d.showWindow();
   }
   
   // Read a number m, 0 <= m < 7, and create an array b of
   // m ints If m not in range, give message and return;
   // otherwise, call numberLess(b,0) and print its result
   // on the Java Console.
   public Object buttonPressed() {
      int m= getIntField(0);
      // If m too small or too big, give message and return
         if (m < 1 || 6 < m) {
            System.out.println("array size is out of
                                range: " + m);
            return null;
         }
      
      int[] b= new int[m];
      
      // inv: b[0..i-1] has been read in
      for (int i= 0; i != m; i++)
         {b[i]= getIntField(i+1);}
      System.out.println("no. elements < 0: " +
                          numberLess(b, 0));
      return null;
   }
   
   // = no. elements of b that are less than c
   public static int numberLess(int[] b, int v) {
      int c= 0; 
      // inv: 0 <= i <= b.length  and
      //      c = (no.elements of [0..b.i-1] less than v)
      for (int i= 0; i != b.length; i++) {
         if (b[i] < v)  
            c= c+1;
      }
      return c;
   }
}
